VERSION 5.00
Begin VB.Form frmDataLoggerSettingsT 
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   Caption         =   "Settings"
   ClientHeight    =   5190
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4530
   LinkTopic       =   "Form1"
   ScaleHeight     =   5190
   ScaleWidth      =   4530
   Begin VB.CommandButton Overwrite 
      Caption         =   "Authorization"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   4
      Top             =   4440
      Width           =   1575
   End
   Begin VB.CheckBox CheckOverwrite 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Overwrite when memory is full"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00000000&
      Height          =   615
      Left            =   2400
      MaskColor       =   &H00FFFFFF&
      TabIndex        =   3
      Top             =   3600
      Width           =   1695
   End
   Begin VB.ComboBox DelaySet 
      Appearance      =   0  'Flat
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   2040
      TabIndex        =   2
      Text            =   "delay rate"
      Top             =   360
      Width           =   2175
   End
   Begin VB.CommandButton UpdateDelay 
      BackColor       =   &H80000010&
      Caption         =   "update"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   1920
      Width           =   1575
   End
   Begin VB.PictureBox chrono 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   1500
      Left            =   240
      Picture         =   "frmDataLoggerSettingsT.frx":0000
      ScaleHeight     =   1500
      ScaleWidth      =   1500
      TabIndex        =   0
      Top             =   360
      Width           =   1500
   End
   Begin VB.Label TXTDelayInfo 
      BackStyle       =   0  'Transparent
      Caption         =   "Delay between two temperatures measurement"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   735
      Left            =   2160
      TabIndex        =   5
      Top             =   960
      Width           =   1815
   End
   Begin VB.Line Line1 
      X1              =   240
      X2              =   4320
      Y1              =   2640
      Y2              =   2640
   End
   Begin VB.Image Image1 
      Height          =   1425
      Left            =   240
      Picture         =   "frmDataLoggerSettingsT.frx":7572
      Top             =   3000
      Width           =   1440
   End
End
Attribute VB_Name = "frmDataLoggerSettingsT"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private Sub CheckOverwrite_Click()
Overwrite.Enabled = True
End Sub

Private Sub Form_Load()

Dim Read_Single_Result As String
Dim Delay_Byte As String
Dim Data_To_Send As String
Dim Txt_Message_Box As String
Dim iShowStartButton As Integer
Dim DelayIntValue As Integer
Dim Overwrite_Byte As String

frmDataLoggerSettingsT.Top = 2000
frmDataLoggerSettingsT.Left = 5300
frmDataLoggerSettingsT.Width = 4600
frmDataLoggerSettingsT.Height = 5700

    DelaySet.AddItem "256ms"
    DelaySet.ItemData(DelaySet.NewIndex) = 11
    DelaySet.AddItem "512ms"
    DelaySet.ItemData(DelaySet.NewIndex) = 12
    DelaySet.AddItem "1s  (dynamic view)"
    DelaySet.ItemData(DelaySet.NewIndex) = 13
    DelaySet.AddItem "2s"
    DelaySet.ItemData(DelaySet.NewIndex) = 14
    DelaySet.AddItem "12s"
    DelaySet.ItemData(DelaySet.NewIndex) = 15
    DelaySet.AddItem "30s"
    DelaySet.ItemData(DelaySet.NewIndex) = 16
    
'******************** INVENTORY ************************
    If (Inventory_DataLogger = SUCCEDED) Then

        '****************** READ BLOCK 0000 ******************
        Read_Single_Result = ReadRF_single_DataLogger(0, 4, 2)
        If (iReadRF_Success = SUCCEDED) Then
            Data_To_Send = Read_Single_Result
            Delay_Byte = Mid(Read_Single_Result, 5, 2)
            Overwrite_Byte = Mid(Read_Single_Result, 3, 2)
            DelayIntValue = CInt("&h" & Delay_Byte)
            
            If (Overwrite_Byte = AUTHORIZED) Then
                CheckOverwrite.Value = 1
            Else
                CheckOverwrite.Value = 0
            End If
            
            If (DelayIntValue = 11) Then
                DelaySet.Text = "256ms"
            ElseIf (DelayIntValue = 12) Then
                DelaySet.Text = "512ms"
            ElseIf (DelayIntValue = 13) Then
                DelaySet.Text = "1s  (dynamic view)"
            ElseIf (DelayIntValue = 14) Then
                DelaySet.Text = "2s"
            ElseIf (DelayIntValue = 15) Then
                DelaySet.Text = "12s"
            ElseIf (DelayIntValue = 16) Then
                DelaySet.Text = "30s"
            End If
        End If
    End If

End Sub
  
Private Sub DelaySet_click()

    Select Case DelaySet.Text
    
        Case "256ms"
            UpdateDelay.Enabled = True
        Case "512ms"
            UpdateDelay.Enabled = True
        Case "1s  (dynamic view)"
            UpdateDelay.Enabled = True
        Case "2s"
            UpdateDelay.Enabled = True
        Case "12s"
            UpdateDelay.Enabled = True
        Case "30s"
            UpdateDelay.Enabled = True
    End Select

End Sub

Private Sub Overwrite_Click()

Dim Overwrite_Byte As String
Dim Read_Single_Result As String
Dim Data_To_Send As String

'****************** READ BLOCK 0000 ******************
Read_Single_Result = ReadRF_single_DataLogger(0, 4, 2)
If (iReadRF_Success = SUCCEDED) Then
    Data_To_Send = Read_Single_Result
    Overwrite_Byte = Mid(Read_Single_Result, 3, 2)

    If (CheckOverwrite.Value = 1) Then
        Mid(Data_To_Send, 3, 2) = AUTHORIZED
    Else
        Mid(Data_To_Send, 3, 2) = NON_AUTHORIZED
    End If
    
        '****************** WRITE BLOCK 0000 *********************
        If (WriteSingleBlockRF_DataLogger(0, Data_To_Send, 4, 2) = SUCCEDED) Then
            MsgBox "** OK **   Overwrite has been updated", _
                    vbInformation, _
                    "Information window"
        Else
            MsgBox "Overwrite has not been updated !! Please make sure that the data logger is close enough to the reader and retry", _
                    vbCritical, _
                    "Information window"
        iAnimation = ANIM_NORF
        End If
Else
    MsgBox "Overwrite has not been updated !! Please make sure that the data logger is close enough to the reader and retry", _
            vbCritical, _
            "Information window"
End If
End Sub



Private Sub UpdateDelay_Click()

Dim DelayValue As Double
Dim Index As Double
Dim Delay As String
Dim Delay_Byte As String
Dim Read_Single_Result As String
Dim Data_To_Send As String

Index = DelaySet.ListIndex
DelayValue = DelaySet.ItemData(Index)
If (DelayValue < 16) Then
    Delay = "0" & Hex$(DelayValue)
Else
    Delay = Hex$(DelayValue)
End If

'****************** READ BLOCK 0000 ******************
Read_Single_Result = ReadRF_single_DataLogger(0, 4, 2)
If (iReadRF_Success = SUCCEDED) Then
    Data_To_Send = Read_Single_Result
    Delay_Byte = Mid(Read_Single_Result, 5, 2)

    If (Delay <> Delay_Byte) Then
        Mid(Data_To_Send, 5, 2) = Delay
        Mid(Data_To_Send, 1, 2) = UPDATE
        
        '****************** WRITE BLOCK 0000 *********************
        If (WriteSingleBlockRF_DataLogger(0, Data_To_Send, 4, 2) = SUCCEDED) Then
            If (Delay = "0D") Then
                iRealTimeGraph = PERMITED
            ElseIf (Delay = "0C") Then
                iRealTimeGraph = PERMITED
            Else
                iRealTimeGraph = NON_PERMITED
            End If
            MsgBox "** OK **   Delay has been changed", _
                    vbInformation, _
                    "Information window"
        Else
            MsgBox "Delay has NOT been changed !! Please make sure that the data logger is close enough to the reader and retry", _
                    vbCritical, _
                    "Information window"
        iAnimation = ANIM_NORF
        End If
    Else
        MsgBox "The delay is already set to this value", _
                vbInformation, _
                "Information window"
    End If

Else
    MsgBox "Delay has NOT been changed !! Please make sure that the data logger is close enough to the reader and retry", _
            vbCritical, _
            "Information window"
End If
End Sub


'------------------------------------------------------------------------------
'-------------------------- ReadRF_single_DataLogger --------------------------
'------------------------------------------------------------------------------
' the string contains the four read bytes or one of the folowing expressions
' "no_detected_answer"
' "no_tag_answer "
'------------------------------------------------------------------------------
' Example : sResult = ReadRF_single_DataLogger(0, 4, 2)
' means that you will read 4 bytes at the address 0 coded on two bytes (@0000)
'------------------------------------------------------------------------------
Function ReadRF_single_DataLogger(lngAddLow As Long, lngDataSize As Long, lngNbByteAddress As Long) As String

Dim strRequestDatas As String
Dim lngRequestDatasLen As Long
Dim lngRspLength As Long
Dim strResponseDatas As String * 512
Dim lngResponseDatasLen As Long
Dim bytRequestFlag As Byte
Dim strRequestFlag As String
Dim strResponseBlocking As String
Dim lngadd As Long
Dim strTmpData As String
Dim strAddress As String
Dim j As Long
Dim lngStatus As Long
Dim bytOrganization As Long

'Estar
Dim lngEstarCmdSize As Long
Dim pEstarCmd(0 To 63) As Byte
Dim pEstarAnswerSize(0 To 63) As Byte
Dim pEstarAnswer(0 To 63) As Byte

For iPolling = 0 To NB_RETRY

    'The function is considered as FAILED the status only change in case of SUCCESS.
    iReadRF_Success = FAILED
    bytOrganization = 4
    
    lngRspLength = &H38 'response lenght (Feig USB Reader)
    
    'REQUEST FLAG MANAGEMENT + Extended Flag Option FOR DUALMODE
        bytRequestFlag = gbytRequestFlag
        bytRequestFlag = bytRequestFlag And &HDF 'Address Flag = 0
        bytRequestFlag = bytRequestFlag And &HEF 'Select Flag = 0
        
        strRequestFlag = i2hhh(CLng(10), 2) 'format request
    
        lngadd = lngAddLow
    
        strAddress = i2hhh(lngadd And &HFF, 2)
        strAddress = strAddress & i2hhh((lngadd \ (2 ^ 8)) And &HFF, 2)
                                   
        strRequestDatas = strRequestFlag & _
                            cstrCmdReadSingleBlock & _
                            strAddress
          
        strRequestDatas = Replace(strRequestDatas, " ", "")
        lngRequestDatasLen = Len(strRequestDatas)
                   
        'READER SELECTION
        Select Case giSelectedReader_RF
            
            Case cReader_RF_Feig_USB 'FEIG reader
                strRequestDatas = gstr0xBFcmd_Reserved_7_8 & strRequestDatas
                lngRequestDatasLen = Len(strRequestDatas)
                lngStatus = FEISC_0xBF_ISOTranspCmd(lngAttachedDeviceHandle(1), &HFF, &H1, lngRspLength, strRequestDatas, lngRequestDatasLen, strResponseDatas, lngResponseDatasLen, 1)
            
            Case cReader_RF_eStar_USB ' estar reader
                strResponseDatas = ""
                lngRequestDatasLen = Len(strRequestDatas) / 2
                strRequestDatas = gstr_estar_0xB0FF_cmd & i2hhh(lngRequestDatasLen, 2) & strRequestDatas
                lngEstarCmdSize = Len(strRequestDatas) / 2
                For j = 0 To lngEstarCmdSize - 1
                    pEstarCmd(j) = CByte("&h" & Mid(strRequestDatas, (j * 2) + 1, 2))
                Next j
                lngStatus = API_USBAll(hcomm_public, lngEstarCmdSize, pEstarCmd(0), pEstarAnswerSize(0), pEstarAnswer(0))
                If (lngStatus = 4) Then
                            strDataMsgEssai = "The software lost the communication with the eStar reader." & vbCrLf & _
                                              "Please, close the sofware window." & vbCrLf & _
                                              "Disconnect the eStar reader and connect it again." & vbCrLf & _
                                              "You will be able to launch again the application."
                            Call MsgBox(strDataMsgEssai, vbInformation, "eStar reader problem")
                            
                End If
                For j = 0 To pEstarAnswerSize(0) - 1
                    'bytTemp = pEstarAnswer(j)
                    Mid(strResponseDatas, (j * 2) + 1, 2) = i2hhh(CLng(pEstarAnswer(j)), 2)
                Next j
                
        End Select
                        
        lngResponseDatasLen = Len(strResponseDatas)
    
        If (lngResponseDatasLen > 0) Then
            
                If (Mid(strResponseDatas, 1, 2) = "00") Then
     
                    strResponseBlocking = "" 'format
                    strResponseDatas = Replace(Mid(strResponseDatas, 3, lngResponseDatasLen - 6), " ", "")
                    
                    strTmpData = "" 'format
                    
                    For j = 0 To lngDataSize - 1
                        strTmpData = strTmpData & Mid(strResponseDatas, 1 + j * 2, 2)
                    Next j
                    
                    'the function is considered as SUCCEEDED only at this moment.
                    iReadRF_Success = SUCCEDED
                    iPolling = NB_RETRY 'stop polling loop
                                           
                End If
        Else
            strTmpData = "no_detected_answer"
            iReadRF_Success = FAILED
        End If
            
        DoEvents
        
    'the function return the read data
    ReadRF_single_DataLogger = strTmpData
    
Next iPolling
    
End Function

'------------------------------------------------------------------------------
'---------------------------- Inventory_DataLogger ----------------------------
'------------------------------------------------------------------------------
' Inventory_DataLogger return SUCCEDED or FAILED
'------------------------------------------------------------------------------
Function Inventory_DataLogger() As Integer

Dim strRequestDatas As String
Dim lngRequestDatasLen As Long
Dim lngRspLength As Long
Dim strResponseDatas As String * 512
Dim lngResponseDatasLen As Long
Dim strRequestFlag As String
Dim strInventoryOptionalAFI As String
Dim lngTranspNumber As Long
Dim str1transponder As String
Dim strUID As String
Dim strDSFID As String
Dim strTrType As String
Dim j As Long
Dim lngStatus As Long

'Estar
Dim lngEstarCmdSize As Long
Dim pEstarCmd(0 To 63) As Byte
Dim pEstarAnswerSize(0 To 63) As Byte
Dim pEstarAnswer(0 To 63) As Byte

Dim txtInventoryMaskLenght As String
Dim strVerifUID As String

For iPolling = 0 To NB_RETRY
    
    'The function is considered as FAILED the status only change in case of SUCCESS.
    Inventory_DataLogger = FAILED
    
    lngRspLength = &H60 'response lenght
     
    'SET FLAG ARBITRATION
    strRequestFlag = "26"
    
    strRequestDatas = strRequestFlag & _
                      cstrCmdInventory & _
                      strInventoryOptionalAFI & _
                      txtInventoryMaskLenght
                      
     strRequestDatas = Replace(strRequestDatas, " ", "") 'format request
     lngRequestDatasLen = Len(strRequestDatas)
            
        'READER SELECTION = FEIG ONLY
        Select Case giSelectedReader_RF
            
            Case cReader_RF_Feig_USB 'Feig Reader
                strRequestDatas = "0100" 'Inventory code command
                lngRequestDatasLen = Len(strRequestDatas)
                lngStatus = FEISC_0xB0_ISOCmd(lngAttachedDeviceHandle(1), &HFF, strRequestDatas, lngRequestDatasLen, strResponseDatas, lngResponseDatasLen, 1)
            
            Case cReader_RF_eStar_USB 'estar Reader
                strResponseDatas = ""
                lngRequestDatasLen = Len(strRequestDatas) / 2
                strRequestDatas = gstr_estar_0xB0_cmd & "01060000"
                lngEstarCmdSize = Len(strRequestDatas) / 2
                For j = 0 To lngEstarCmdSize - 1
                    pEstarCmd(j) = CByte("&h" & Mid(strRequestDatas, (j * 2) + 1, 2))
                Next j
                lngStatus = API_USBAll(hcomm_public, lngEstarCmdSize, pEstarCmd(0), pEstarAnswerSize(0), pEstarAnswer(0))
                If (lngStatus = 4) Then
                            strDataMsgEssai = "The software lost the communication with the eStar reader." & vbCrLf & _
                                              "Please, close the sofware window." & vbCrLf & _
                                              "Disconnect the eStar reader and connect it again." & vbCrLf & _
                                              "You will be able to launch again the application."
                            Call MsgBox(strDataMsgEssai, vbInformation, "eStar reader problem")
                            GoTo CmdInventory_FEIG_ESTAR_xTags_DK_Error
                End If
                For j = 0 To pEstarAnswerSize(0) - 1
                    Mid(strResponseDatas, (j * 2) + 1, 2) = i2hhh(CLng(pEstarAnswer(j)), 2)
                Next j
        End Select
        
        strResponseDatas = Replace(strResponseDatas, " ", "") 'format response
        lngResponseDatasLen = Len(strResponseDatas) / 2
        
        If (lngResponseDatasLen > 0 And lngStatus = 0) Then
                                
            lngTranspNumber = CLng("&h" & Mid(strResponseDatas, 1, 2)) 'number of transponder in the reader field
    
            If (lngTranspNumber = 1) Then
                    
                str1transponder = Mid(strResponseDatas, 3, 20)
                strTrType = Mid(str1transponder, 1, 2)
                    
                strDSFID = Mid(str1transponder, 3, 2)
    
                If (giSelectedReader_RF = cReader_RF_Feig_USB) Then
                    strUID = Mid(str1transponder, 5, 16)
                ElseIf (giSelectedReader_RF = cReader_RF_eStar_USB) Then
                    strUID = ""
                    For j = 0 To 7
                        strUID = strUID & Mid(str1transponder, 3 + (16 - j * 2), 2)
                    Next j
                End If
        
                strVerifUID = Mid(strUID, 1, 6)
                If (strVerifUID = "E0022C" Or strVerifUID = "E0022D" Or strVerifUID = "E0022E" Or strVerifUID = "E0022F") Then
                    'the function is considered as SUCCEEDED only at this moment.
                    Inventory_DataLogger = SUCCEDED
                    iPolling = NB_RETRY 'stop the polling loop
                Else
                    If (iPolling = NB_RETRY) Then
                        MsgBox "the present product is not a M24LR64 Data Logger", _
                        vbInformation, _
                        "Information window"
                    End If
                End If
                
            ElseIf (lngTranspNumber > 1) Then
                If (iPolling = NB_RETRY) Then
                MsgBox "Please make sure that there is only one product in the reader field", _
                        vbExclamation, _
                        "Information window"
                End If
            End If
        
        Else
            If (iPolling = NB_RETRY) Then
                MsgBox "Please make sure that the product is close enough to the reader", _
                    vbInformation, _
                    "Information window"
            End If
        End If
        
Next iPolling
         
'release all TAG after Inventory (and Stay Quiet)
Select Case giSelectedReader_RF
    Case cReader_RF_Feig_USB
        'FORCE NON-ADDRESSED MODE
        Call ResetToReadyRF_DataLogger
        If (ResetToReadyRF_DataLogger = FAILED) Then
            Inventory_DataLogger = FAILED
        End If
    Case cReader_RF_eStar_USB
        'FORCE NON-ADDRESSED MODE
        Call ResetToReadyRF_DataLogger
        If (ResetToReadyRF_DataLogger = FAILED) Then
            Inventory_DataLogger = FAILED
        End If
End Select
'Loop While (bLoopInventory = True)
CmdInventory_FEIG_ESTAR_xTags_DK_Error:
    
End Function
'------------------------------------------------------------------------------
'-------------------------- ResetToReadyRF_DataLogger -------------------------
'------------------------------------------------------------------------------
' ResetToReadyRF_DataLogger return SUCCEDED or FAILED
'------------------------------------------------------------------------------
Function ResetToReadyRF_DataLogger() As Integer
Dim strRequestDatas As String
Dim lngRequestDatasLen As Long
Dim lngRspLength As Long
Dim strResponseDatas As String * 512
Dim lngResponseDatasLen As Long
Dim bytRequestFlag As Byte
Dim strRequestFlag As String
Dim strTmpData As String
Dim j As Long
Dim lngStatus As Long

'Estar
Dim lngEstarCmdSize As Long
Dim pEstarCmd(0 To 63) As Byte
Dim pEstarAnswerSize(0 To 63) As Byte
Dim pEstarAnswer(0 To 63) As Byte

For iPolling = 0 To NB_RETRY

    'The function is considered as FAILED the status only change in case of SUCCESS.
    ResetToReadyRF_DataLogger = FAILED
    
    'OxBF ISO15693 TRANSPARENT COMMAND PARAMETERS
    gstr0xBFcmd_Reserved_7_8 = "021F"
    gstr0xBFcmd_EofPulseDelay_9_10 = "021F"
    
    lngRspLength = &H38 'response lenght
    
    'REQUEST FLAG MANAGEMENT
    bytRequestFlag = 2
    strRequestFlag = i2hhh(CLng(bytRequestFlag), 2)
        
    '--- NON-ADDRESSED MODE or SELECT MODE
    strRequestDatas = strRequestFlag & _
                      cstrCmdResetToReady

    strRequestDatas = Replace(strRequestDatas, " ", "") 'format the request
    lngRequestDatasLen = Len(strRequestDatas)
          
    'READER SELECTION to work with Both FEIG & estar
    Select Case giSelectedReader_RF
        
        Case cReader_RF_Feig_USB 'Feig Reader
            strRequestDatas = gstr0xBFcmd_Reserved_7_8 & strRequestDatas
            lngRequestDatasLen = Len(strRequestDatas)
            lngStatus = FEISC_0xBF_ISOTranspCmd(lngAttachedDeviceHandle(1), &HFF, &H2, lngRspLength, strRequestDatas, lngRequestDatasLen, strResponseDatas, lngResponseDatasLen, 1)
        
        Case cReader_RF_eStar_USB 'eStar Reader
            strResponseDatas = ""
            lngRequestDatasLen = Len(strRequestDatas) / 2
            strRequestDatas = gstr_estar_0xB0FF_cmd & i2hhh(lngRequestDatasLen, 2) & strRequestDatas
            lngEstarCmdSize = Len(strRequestDatas) / 2
            For j = 0 To lngEstarCmdSize - 1
                pEstarCmd(j) = CByte("&h" & Mid(strRequestDatas, (j * 2) + 1, 2))
            Next j
            lngStatus = API_USBAll(hcomm_public, lngEstarCmdSize, pEstarCmd(0), pEstarAnswerSize(0), pEstarAnswer(0))
            For j = 0 To pEstarAnswerSize(0) - 1
                Mid(strResponseDatas, (j * 2) + 1, 2) = i2hhh(CLng(pEstarAnswer(j)), 2)
            Next j
    End Select
        
    lngResponseDatasLen = Len(strResponseDatas) / 2
    
    If (lngResponseDatasLen > 0) Then
        
        If (Mid(strResponseDatas, 1, 2) = "00") Then
            'the function is considered as SUCCEEDED only at this moment.
            ResetToReadyRF_DataLogger = SUCCEDED 'stop the polling loop
            iPolling = NB_RETRY
        End If
        
    End If
        
Next iPolling
        
End Function

'------------------------------------------------------------------------------
'-------------------------- WriteSingleBlockRF_DataLogger --------------------------
'------------------------------------------------------------------------------
'the string lngadd contains the four eeprom address bytes
'the string strData contains the four bytes to be written
'------------------------------------------------------------------------------
' Example : sResult = ReadRF_single_DataLogger(0, 4, 2)
' means that you will read 4 bytes at the address 0 coded on two bytes (@0000)
'------------------------------------------------------------------------------
' -------------------------------------------------------------------------------
Function WriteSingleBlockRF_DataLogger(lngadd As Long, strData As String, lngDataSize As Long, lngNbByteAddress As Byte) As Integer

Dim strRequestDatas As String
Dim lngRequestDatasLen As Long
Dim lngRspLength As Long
Dim strResponseDatas As String * 512
Dim lngResponseDatasLen As Long
Dim bytRequestFlag As Byte
Dim strRequestFlag As String
Dim strAddress As String
Dim iDataRate  As Integer
Dim j As Long
Dim lngStatus As Long

'Estar
Dim lngEstarCmdSize As Long
Dim pEstarCmd(0 To 63) As Byte
Dim pEstarAnswerSize(0 To 63) As Byte
Dim pEstarAnswer(0 To 63) As Byte

For iPolling = 0 To NB_RETRY

    'The function is considered as FAILED the status only change in case of SUCCESS.
    WriteSingleBlockRF_DataLogger = FAILED
    
    lngRspLength = &H38 'response lenght
    
    'REQUEST FLAG MANAGEMENT
        bytRequestFlag = 10
        iDataRate = 1
        
        strRequestFlag = i2hhh(CLng(bytRequestFlag), 2)
        
        strAddress = i2hhh(lngadd And &HFF, 2)
        strAddress = strAddress & i2hhh((lngadd \ (2 ^ 8)) And &HFF, 2)
                                                             
        strRequestDatas = strRequestFlag & _
                      cstrCmdWriteSingleBlock & _
                      strAddress & _
                      strData
        
        strRequestDatas = Replace(strRequestDatas, " ", "")
        lngRequestDatasLen = Len(strRequestDatas)
              
        'READER SELECTION
        Select Case giSelectedReader_RF
            
            Case cReader_RF_Feig_USB 'FEIG reader
                strRequestDatas = gstr0xBFcmd_Reserved_7_8 & strRequestDatas
                lngRequestDatasLen = Len(strRequestDatas)
                lngStatus = FEISC_0xBF_ISOTranspCmd(lngAttachedDeviceHandle(1), &HFF, &H2, lngRspLength, strRequestDatas, lngRequestDatasLen, strResponseDatas, lngResponseDatasLen, 1)
            
            Case cReader_RF_eStar_USB ' estar reader
                strResponseDatas = ""
                lngRequestDatasLen = Len(strRequestDatas) / 2
                strRequestDatas = gstr_estar_0xB0FF_cmd & i2hhh(lngRequestDatasLen, 2) & strRequestDatas
                lngEstarCmdSize = Len(strRequestDatas) / 2
                For j = 0 To lngEstarCmdSize - 1
                    pEstarCmd(j) = CByte("&h" & Mid(strRequestDatas, (j * 2) + 1, 2))
                Next j
                lngStatus = API_USBAll(hcomm_public, lngEstarCmdSize, pEstarCmd(0), pEstarAnswerSize(0), pEstarAnswer(0))
                If (lngStatus = 4) Then
                            strDataMsgEssai = "The software lost the communication with the eStar reader." & vbCrLf & _
                                              "Please, close the sofware window." & vbCrLf & _
                                              "Disconnect the eStar reader and connect it again." & vbCrLf & _
                                              "You will be able to launch again the application."
                            If (iPolling = NB_RETRY) Then
                                Call MsgBox(strDataMsgEssai, vbInformation, "eStar reader problem") 'graphic
                            End If
                End If
                For j = 0 To pEstarAnswerSize(0) - 1
                    Mid(strResponseDatas, (j * 2) + 1, 2) = i2hhh(CLng(pEstarAnswer(j)), 2)
                Next j
        End Select
        
        lngResponseDatasLen = Len(strResponseDatas) / 2
    
        If (lngResponseDatasLen > 0) Then
                
                If (Mid(strResponseDatas, 1, 2) = "00") Then
                    'the function is considered as SUCCEEDED only at this moment.
                    WriteSingleBlockRF_DataLogger = SUCCEDED
                    iPolling = NB_RETRY 'stop polling loop
                End If
                    
        End If
        
Next iPolling

End Function

Public Function i2hhh(i As Long, digit As Byte) As String
Dim strHexa As String

  strHexa = Hex(i)

  Select Case (digit - Len(strHexa))
  Case 0
    i2hhh = strHexa
  Case 1
    i2hhh = "0" & strHexa
  Case 2
    i2hhh = "00" & strHexa
  Case 3
    i2hhh = "000" & strHexa
  Case 4
    i2hhh = "0000" & strHexa
  Case 5
    i2hhh = "00000" & strHexa
  Case 6
    i2hhh = "000000" & strHexa
  Case 7
    i2hhh = "0000000" & strHexa
  Case Else
    i2hhh = strHexa
  End Select

End Function
